.\" Automatically generated from an mdoc input file.  Do not edit.
.\" zip_open.mdoc -- open zip archive
.\" Copyright (C) 2003-2018 Dieter Baron and Thomas Klausner
.\"
.\" This file is part of libzip, a library to manipulate ZIP archives.
.\" The authors can be contacted at <libzip@nih.at>
.\"
.\" Redistribution and use in source and binary forms, with or without
.\" modification, are permitted provided that the following conditions
.\" are met:
.\" 1. Redistributions of source code must retain the above copyright
.\"    notice, this list of conditions and the following disclaimer.
.\" 2. Redistributions in binary form must reproduce the above copyright
.\"    notice, this list of conditions and the following disclaimer in
.\"    the documentation and/or other materials provided with the
.\"    distribution.
.\" 3. The names of the authors may not be used to endorse or promote
.\"    products derived from this software without specific prior
.\"    written permission.
.\"
.\" THIS SOFTWARE IS PROVIDED BY THE AUTHORS ``AS IS'' AND ANY EXPRESS
.\" OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
.\" WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
.\" ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHORS BE LIABLE FOR ANY
.\" DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
.\" DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE
.\" GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
.\" INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER
.\" IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR
.\" OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN
.\" IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
.\"
.TH "ZIP_OPEN" "3" "December 18, 2017" "NiH" "Library Functions Manual"
.nh
.if n .ad l
.SH "NAME"
\fBzip_open\fR,
\fBzip_open_from_source\fR
\- open zip archive
.SH "LIBRARY"
libzip (-lzip)
.SH "SYNOPSIS"
\fB#include <zip.h>\fR
.sp
\fIzip_t *\fR
.br
.PD 0
.HP 4n
\fBzip_open\fR(\fIconst\ char\ *path\fR, \fIint\ flags\fR, \fIint\ *errorp\fR);
.PD
.PP
\fIzip_t *\fR
.br
.PD 0
.HP 4n
\fBzip_open_from_source\fR(\fIzip_source_t\ *zs\fR, \fIint\ flags\fR, \fIzip_error_t\ *ze\fR);
.PD
.SH "DESCRIPTION"
The
\fBzip_open\fR()
function opens the zip archive specified by
\fIpath\fR
and returns a pointer to a
\fIstruct zip\fR,
used to manipulate the archive.
The
\fIflags\fR
are specified by
\fIor\fR'ing
the following values, or 0 for none of them.
.RS 6n
.TP 15n
\fRZIP_CHECKCONS\fR
Perform additional stricter consistency checks on the archive, and
error if they fail.
.TP 15n
\fRZIP_CREATE\fR
Create the archive if it does not exist.
.TP 15n
\fRZIP_EXCL\fR
Error if archive already exists.
.TP 15n
\fRZIP_TRUNCATE\fR
If archive exists, ignore its current contents.
In other words, handle it the same way as an empty archive.
.TP 15n
\fRZIP_RDONLY\fR
Open archive in read-only mode.
.RE
.PP
If an error occurs and
\fIerrorp\fR
is
non-\fRNULL\fR,
it will be set to the corresponding error code.
.PP
The
\fBzip_open_from_source\fR()
function opens a zip archive encapsulated by the zip_source
\fIzs\fR
using the provided
\fIflags\fR.
In case of error, the zip_error
\fIze\fR
is filled in.
.SH "RETURN VALUES"
Upon successful completion
\fBzip_open\fR()
and
\fBzip_open_from_source\fR()
return a
\fIstruct zip\fR
pointer.
Otherwise,
\fRNULL\fR
is returned and
\fBzip_open\fR()
sets
\fI*errorp\fR
to indicate the error, while
\fBzip_open_from\fR(\fIsource\fR)
sets
\fIze\fR
to indicate the error.
.SH "ERRORS"
The archive specified by
\fIpath\fR
is opened unless:
.TP 19n
[\fRZIP_ER_EXISTS\fR]
The file specified by
\fIpath\fR
exists and
\fRZIP_EXCL\fR
is set.
.TP 19n
[\fRZIP_ER_INCONS\fR]
Inconsistencies were found in the file specified by
\fIpath\fR.
This error is often caused by specifying
\fRZIP_CHECKCONS\fR
but can also happen without it.
.TP 19n
[\fRZIP_ER_INVAL\fR]
The
\fIpath\fR
argument is
\fRNULL\fR.
.TP 19n
[\fRZIP_ER_MEMORY\fR]
Required memory could not be allocated.
.TP 19n
[\fRZIP_ER_NOENT\fR]
The file specified by
\fIpath\fR
does not exist and
\fRZIP_CREATE\fR
is not set.
.TP 19n
[\fRZIP_ER_NOZIP\fR]
The file specified by
\fIpath\fR
is not a zip archive.
.TP 19n
[\fRZIP_ER_OPEN\fR]
The file specified by
\fIpath\fR
could not be opened.
.TP 19n
[\fRZIP_ER_READ\fR]
A read error occurred; see
\fIerrno\fR
for details.
.TP 19n
[\fRZIP_ER_SEEK\fR]
The file specified by
\fIpath\fR
does not allow seeks.
.SH "SEE ALSO"
libzip(3),
zip_close(3),
zip_error_strerror(3),
zip_fdopen(3)
.SH "HISTORY"
\fBzip_open\fR()
and
\fBzip_open_from_source\fR()
were added in libzip 1.0.
.SH "AUTHORS"
Dieter Baron <\fIdillo@nih.at\fR>
and
Thomas Klausner <\fItk@giga.or.at\fR>
